<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require('fpdf.php');

$data = $_POST;

$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',16);
$pdf->SetTextColor(212,175,55);
$pdf->Cell(0,10,'Isoloft Besteloverzicht',0,1);
$pdf->Image('logo_isoloft.png',160,10,40);
$pdf->Ln(15);

$pdf->SetFont('Arial','',11);
$pdf->SetTextColor(0,0,0);

foreach ($data as $key => $value) {
    if ($value !== '') {
        $pdf->Cell(0,7, "$key: $value", 0, 1);
    }
}

$naam = !empty($data['Klantnaam'])? preg_replace('/[^A-Za-z0-9]/','_',$data['Klantnaam']):'onbekend';
$pdf->Output('D', "Isoloft besteloverzicht_{$naam}.pdf");
exit;
?>